--
-- PostgreSQL database dump
--

-- Dumped from database version 11.1
-- Dumped by pg_dump version 11.1


SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: compute_archive_size(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.compute_archive_size() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    target_path text;
BEGIN
    IF (TG_OP = 'DELETE') THEN
        target_path = OLD."path";
    ELSE
        target_path = NEW."path";
    END IF;

    UPDATE "archivePaths" SET "curSize"=subquery.*
    FROM COALESCE((SELECT SUM("size") sumSize FROM "files" WHERE "path"=target_path), 0) AS subquery
    WHERE "path"=target_path;
    
    RETURN NULL;
END;
$$;


ALTER FUNCTION public.compute_archive_size() OWNER TO postgres;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: applicationEvents; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."applicationEvents" (
    "dateTime" timestamp without time zone NOT NULL,
    "eventType" integer NOT NULL,
    description text
);


ALTER TABLE public."applicationEvents" OWNER TO postgres;

--
-- Name: archiveFiles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."archiveFiles" (
    "ID_Archive" integer NOT NULL,
    "ID_Channel" integer NOT NULL,
    "streamType" integer NOT NULL,
    size integer,
    path text,
    filename text,
    "startDateTime" timestamp without time zone NOT NULL,
    "endDateTime" timestamp without time zone,
    duration interval,
    "startReason" integer,
    "endReason" integer,
    "startIndex" integer NOT NULL
);


ALTER TABLE public."archiveFiles" OWNER TO postgres;

--
-- Name: archivePaths; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."archivePaths" (
    path text NOT NULL,
    "ID_Archive" integer,
    "maximumSize" integer,
    "ID_Path" integer NOT NULL,
    "minFreeSpace" integer,
    "curSize" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public."archivePaths" OWNER TO postgres;

--
-- Name: archives; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.archives (
    "ID_Archive" integer NOT NULL,
    name text,
    enabled boolean,
    "minimalSpace" integer,
    rewrite boolean,
    "checkMaximumSize" boolean,
    "maxDepth" integer DEFAULT 0 NOT NULL,
    "splitPolicy" integer not null default 0,
    "maxFileSize" integer not null default 100,
    "maxFileDuration" integer not null default 5
);


ALTER TABLE public.archives OWNER TO postgres;

--
-- Name: bookmarks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.bookmarks (
    "ID" integer NOT NULL,
    type integer DEFAULT 0 NOT NULL,
    "ID_Channels" text DEFAULT ''::text NOT NULL,
    "startTime" timestamp without time zone NOT NULL,
    comment text DEFAULT ''::text NOT NULL
);


ALTER TABLE public.bookmarks OWNER TO postgres;

--
-- Name: bookmarks_ID_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public."bookmarks_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public."bookmarks_ID_seq" OWNER TO postgres;

--
-- Name: bookmarks_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public."bookmarks_ID_seq" OWNED BY public.bookmarks."ID";


--
-- Name: channel_index; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.channel_index
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    MAXVALUE 512
    CACHE 1;


ALTER TABLE public.channel_index OWNER TO postgres;

--
-- Name: channels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.channels (
    "ID_Channel" integer NOT NULL,
    name text DEFAULT ('Channel '::text || nextval('public.channel_index'::regclass)),
    "ipAddress" text DEFAULT '...'::text,
    port integer DEFAULT 80,
    login text,
    password text,
    "mainStream" text DEFAULT '/onvif/device_service'::text,
    "subStream" text DEFAULT '/'::text,
    enabled boolean DEFAULT false,
    "transportProtocol" integer DEFAULT 1,
    "ID_Schedule" integer DEFAULT 0,
    "ID_Archive" integer DEFAULT 0,
    protocol integer DEFAULT 0,
    transmittable boolean DEFAULT false,
    "sourceIndex" integer DEFAULT 1,
    modules integer DEFAULT 0 NOT NULL,
    packets text DEFAULT ''::text,
    "recSound" boolean DEFAULT false NOT NULL,
    "hwDecoder" boolean DEFAULT false NOT NULL,
    latency integer DEFAULT 500 NOT NULL,
    ptz integer DEFAULT 0 NOT NULL,
    "rtspClient" integer not null default 0,
    "secondPort" integer not null default 554
);


ALTER TABLE public.channels OWNER TO postgres;

--
-- Name: connections; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.connections (
    "userId" integer NOT NULL,
    dt timestamp without time zone NOT NULL,
    config boolean NOT NULL
);


ALTER TABLE public.connections OWNER TO postgres;

--
-- Name: customGrids; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."customGrids" (
    "ID_Screen" integer NOT NULL,
    "ID_Cell" integer NOT NULL,
    "fromRow" integer NOT NULL,
    "fromCol" integer NOT NULL,
    "rowSpan" integer DEFAULT 1,
    "colSpan" integer DEFAULT 1
);


ALTER TABLE public."customGrids" OWNER TO postgres;

--
-- Name: delObjsSettings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."delObjsSettings" (
    "ID_Channel" integer NOT NULL,
    x real DEFAULT 0.5 NOT NULL,
    y real DEFAULT 0.5 NOT NULL,
    width real DEFAULT 0.1 NOT NULL,
    height real DEFAULT 0.1 NOT NULL,
    "showArea" boolean DEFAULT false NOT NULL,
    etalon bytea DEFAULT '\x'::bytea,
    "alarmPeriod" integer DEFAULT 3 NOT NULL,
    "postRec" integer DEFAULT 10 NOT NULL
);


ALTER TABLE public."delObjsSettings" OWNER TO postgres;

--
-- Name: events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.events (
    "ID_Channel" integer NOT NULL,
    "dateTime" timestamp without time zone NOT NULL,
    "eventType" integer NOT NULL,
    description text,
    "streamType" integer NOT NULL
);


ALTER TABLE public.events OWNER TO postgres;

--
-- Name: faceDbSettings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."faceDbSettings" (
    "ID_Channel" integer NOT NULL,
    "detectionInterval" integer DEFAULT 1 NOT NULL,
    location text DEFAULT ''::text NOT NULL,
    "minWidth" real DEFAULT 0.07 NOT NULL,
    "minHeight" real DEFAULT 0.07 NOT NULL,
    "eventsStoreDepth" integer DEFAULT 0 NOT NULL,
    stream integer DEFAULT 2 NOT NULL
);


ALTER TABLE public."faceDbSettings" OWNER TO postgres;

--
-- Name: files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.files (
    path text NOT NULL,
    filename text NOT NULL,
    index integer NOT NULL,
    "endFileTime" timestamp without time zone NOT NULL,
    size bigint DEFAULT 0,
    duration bigint DEFAULT 0
);


ALTER TABLE public.files OWNER TO postgres;

--
-- Name: heatmapSettings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."heatmapSettings" (
    "ID_Channel" integer NOT NULL,
    history integer DEFAULT 10 NOT NULL,
    intensity real DEFAULT (0.899999976)::real NOT NULL
);


ALTER TABLE public."heatmapSettings" OWNER TO postgres;

--
-- Name: imageSettings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."imageSettings" (
    "ID_Channel" integer NOT NULL,
    brightness integer DEFAULT 50 NOT NULL,
    contrast integer DEFAULT 50 NOT NULL,
    saturation integer DEFAULT 50 NOT NULL,
    hue integer DEFAULT 50 NOT NULL,
    "enableSharpness" boolean DEFAULT false NOT NULL,
    sharpness integer DEFAULT 0 NOT NULL,
    gamma integer DEFAULT 50 NOT NULL,
    angle integer DEFAULT 0 NOT NULL,
    "flipAction" integer DEFAULT 0 NOT NULL,
    "enableCrop" boolean DEFAULT false NOT NULL,
    "cropLeft" integer DEFAULT 0 NOT NULL,
    "cropRight" integer DEFAULT 0 NOT NULL,
    "cropTop" integer DEFAULT 0 NOT NULL,
    "cropBottom" integer DEFAULT 0 NOT NULL,
    "enableDebarrel" boolean DEFAULT false NOT NULL,
    "debarrelA" real DEFAULT 0 NOT NULL,
    "debarrelB" real DEFAULT 0 NOT NULL,
    "debarrelC" real DEFAULT 0 NOT NULL,
    "debarrelD" real DEFAULT 1 NOT NULL,
    "enableAutoscale" boolean DEFAULT true NOT NULL,
    "enableDefish" boolean DEFAULT false NOT NULL,
    "enableWhiteBalance" boolean DEFAULT false NOT NULL,
    "privateRegions" text DEFAULT ''::text NOT NULL,
    "defishMode" integer DEFAULT 1 NOT NULL,
    "enableDefog" boolean DEFAULT false NOT NULL,
    "defishMethod" integer DEFAULT 3 NOT NULL,
    "defishSAngle" integer DEFAULT 100 NOT NULL,
    "defishHalf" boolean DEFAULT false NOT NULL,
    "aspectRatio" boolean DEFAULT true NOT NULL
);


ALTER TABLE public."imageSettings" OWNER TO postgres;

--
-- Name: journal; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.journal (
    dt timestamp without time zone NOT NULL,
    "group" text DEFAULT 'ALL'::text NOT NULL,
    msg text DEFAULT ''::text NOT NULL
);


ALTER TABLE public.journal OWNER TO postgres;

--
-- Name: lineIntersectionSettings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."lineIntersectionSettings" (
    "ID_Channel" integer NOT NULL,
    "bothWays" boolean DEFAULT false NOT NULL,
    "detectorType" integer DEFAULT 2 NOT NULL,
    "maxWidth" real DEFAULT 0.07 NOT NULL,
    "maxHeight" real DEFAULT 0.07 NOT NULL,
    p1x real DEFAULT 0.1 NOT NULL,
    p1y real DEFAULT 0.2 NOT NULL,
    p2x real DEFAULT 0.2 NOT NULL,
    p2y real DEFAULT 0.2 NOT NULL,
    "resetCounter" time without time zone DEFAULT '00:00:00'::time without time zone NOT NULL,
    "eventsStoreDepth" integer DEFAULT 0 NOT NULL,
    threshold real DEFAULT 0.3 NOT NULL,
    "sendReport" boolean not null default false
);


ALTER TABLE public."lineIntersectionSettings" OWNER TO postgres;

--
-- Name: logon; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.logon (
    type integer NOT NULL,
    ip text DEFAULT '...'::text,
    name text NOT NULL,
    password text
);


ALTER TABLE public.logon OWNER TO postgres;

--
-- Name: motionDetectorSettings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."motionDetectorSettings" (
    "ID_Channel" integer NOT NULL,
    "showMotion" boolean DEFAULT false NOT NULL,
    "showHeatMap" boolean DEFAULT false NOT NULL,
    "heatMapDuration" bigint DEFAULT 200000000 NOT NULL,
    "motionLevel" integer DEFAULT 5 NOT NULL,
    "brushRadius" integer DEFAULT 0 NOT NULL,
    "minAreaSize" real DEFAULT 0.01 NOT NULL,
    "excludedRegions" text DEFAULT ''::text NOT NULL
);


ALTER TABLE public."motionDetectorSettings" OWNER TO postgres;


--
-- Name: scheduleElements; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."scheduleElements" (
    "ID_Schedule" integer NOT NULL,
    "startTime" text NOT NULL,
    "endTime" text,
    type integer,
    "streamType" integer NOT NULL,
    days integer DEFAULT 0 NOT NULL
);


ALTER TABLE public."scheduleElements" OWNER TO postgres;

--
-- Name: scheduleProfiles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."scheduleProfiles" (
    "ID_Schedule" integer NOT NULL,
    name text,
    "manualRecStreamType" integer,
    "preRecTime" integer DEFAULT 5000 NOT NULL,
    "postRecTime" integer DEFAULT 10000 NOT NULL
);


ALTER TABLE public."scheduleProfiles" OWNER TO postgres;

--
-- Name: settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.settings (
    key text NOT NULL,
    value text,
    "userId" integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.settings OWNER TO postgres;

--
-- Name: userAccess; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."userAccess" (
    "ID_User" integer NOT NULL,
    "ID_Channel" integer NOT NULL,
    "liveView" boolean DEFAULT true NOT NULL,
    "archiveView" boolean DEFAULT true NOT NULL,
    sound boolean DEFAULT true NOT NULL
);


ALTER TABLE public."userAccess" OWNER TO postgres;

--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.users (
    "ID_User" integer NOT NULL,
    name text NOT NULL,
    password text,
    access integer NOT NULL
);


ALTER TABLE public.users OWNER TO postgres;

--
-- Name: videoCellItems; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."videoCellItems" (
    "ID_Screen" integer NOT NULL,
    "ID_Cell" integer NOT NULL,
    "ID_Channel" integer NOT NULL
);


ALTER TABLE public."videoCellItems" OWNER TO postgres;

--
-- Name: videoCells; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."videoCells" (
    "ID_Screen" integer NOT NULL,
    "ID_Cell" integer NOT NULL,
    mode integer,
    delay integer,
    "streamType" integer DEFAULT 2 NOT NULL,
    "showChannelName" boolean not null default false
);


ALTER TABLE public."videoCells" OWNER TO postgres;

--
-- Name: videoScreens; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."videoScreens" (
    "ID_Screen" integer NOT NULL,
    name text,
    "gridType" integer,
    "userId" integer DEFAULT 1 NOT NULL
);


ALTER TABLE public."videoScreens" OWNER TO postgres;

--
-- Name: windows; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.windows (
    "ID_Window" integer NOT NULL,
    "ID_Screen" integer DEFAULT 1 NOT NULL,
    "userId" integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.windows OWNER TO postgres;

--
-- Name: bookmarks ID; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.bookmarks ALTER COLUMN "ID" SET DEFAULT nextval('public."bookmarks_ID_seq"'::regclass);


--
-- Name: motionDetectorSettings ID_Channel; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."motionDetectorSettings"
    ADD CONSTRAINT "ID_Channel" PRIMARY KEY ("ID_Channel");


--
-- Name: applicationEvents appPrimaryKey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."applicationEvents"
    ADD CONSTRAINT "appPrimaryKey" PRIMARY KEY ("dateTime", "eventType");


--
-- Name: archives archiveID; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.archives
    ADD CONSTRAINT "archiveID" PRIMARY KEY ("ID_Archive");


--
-- Name: videoCells cell&screenID; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."videoCells"
    ADD CONSTRAINT "cell&screenID" PRIMARY KEY ("ID_Screen", "ID_Cell");


--
-- Name: channels channelID; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.channels
    ADD CONSTRAINT "channelID" PRIMARY KEY ("ID_Channel");


--
-- Name: connections conn_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.connections
    ADD CONSTRAINT conn_pkey PRIMARY KEY ("userId");


--
-- Name: delObjsSettings do_pKey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."delObjsSettings"
    ADD CONSTRAINT "do_pKey" PRIMARY KEY ("ID_Channel");


--
-- Name: events eventsPrimaryKeys; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.events
    ADD CONSTRAINT "eventsPrimaryKeys" PRIMARY KEY ("ID_Channel", "dateTime", "eventType", "streamType");


--
-- Name: faceDbSettings fdb_pKey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."faceDbSettings"
    ADD CONSTRAINT "fdb_pKey" PRIMARY KEY ("ID_Channel");


--
-- Name: files filesPrimaryKeys; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.files
    ADD CONSTRAINT "filesPrimaryKeys" PRIMARY KEY (path, filename, index);


--
-- Name: heatmapSettings hm_pKey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."heatmapSettings"
    ADD CONSTRAINT "hm_pKey" PRIMARY KEY ("ID_Channel");


--
-- Name: imageSettings imageSettings.channelID; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."imageSettings"
    ADD CONSTRAINT "imageSettings.channelID" PRIMARY KEY ("ID_Channel");


--
-- Name: lineIntersectionSettings lis_pKey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."lineIntersectionSettings"
    ADD CONSTRAINT "lis_pKey" PRIMARY KEY ("ID_Channel");


--
-- Name: logon logon_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.logon
    ADD CONSTRAINT logon_pkey PRIMARY KEY (type);


--
-- Name: bookmarks pKey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.bookmarks
    ADD CONSTRAINT "pKey" PRIMARY KEY ("ID");


--
-- Name: archivePaths path; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."archivePaths"
    ADD CONSTRAINT path PRIMARY KEY (path);


--
-- Name: archiveFiles path&filename; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."archiveFiles"
    ADD CONSTRAINT "path&filename" UNIQUE (path, filename);


--
-- Name: scheduleElements pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."scheduleElements"
    ADD CONSTRAINT pkey PRIMARY KEY ("ID_Schedule", "startTime", days, "streamType");


--
-- Name: archiveFiles primaryKeys; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."archiveFiles"
    ADD CONSTRAINT "primaryKeys" PRIMARY KEY ("ID_Archive", "ID_Channel", "startDateTime", "streamType");



--
-- Name: scheduleProfiles scheduleID; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."scheduleProfiles"
    ADD CONSTRAINT "scheduleID" PRIMARY KEY ("ID_Schedule");


--
-- Name: customGrids screen&cell; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."customGrids"
    ADD CONSTRAINT "screen&cell" PRIMARY KEY ("ID_Screen", "ID_Cell");


--
-- Name: videoScreens screen_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."videoScreens"
    ADD CONSTRAINT screen_pkey PRIMARY KEY ("ID_Screen", "userId");


--
-- Name: settings settings_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.settings
    ADD CONSTRAINT settings_pkey PRIMARY KEY (key, "userId");


--
-- Name: userAccess user_channel_pKey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."userAccess"
    ADD CONSTRAINT "user_channel_pKey" PRIMARY KEY ("ID_User", "ID_Channel");


--
-- Name: users users_ID_User_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT "users_ID_User_key" UNIQUE ("ID_User");


--
-- Name: users users_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_pkey PRIMARY KEY ("ID_User", name);


--
-- Name: videoCellItems videoCellItem_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."videoCellItems"
    ADD CONSTRAINT "videoCellItem_pkey" PRIMARY KEY ("ID_Screen", "ID_Cell", "ID_Channel");


--
-- Name: videoScreens videoScreens_ID_Screen_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."videoScreens"
    ADD CONSTRAINT "videoScreens_ID_Screen_key" UNIQUE ("ID_Screen");


--
-- Name: windows windows_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.windows
    ADD CONSTRAINT windows_pkey PRIMARY KEY ("ID_Window", "userId");


--
-- Name: fki_ID_Archive; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "fki_ID_Archive" ON public."archivePaths" USING btree ("ID_Archive");


--
-- Name: fki_ID_Archive->archives; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "fki_ID_Archive->archives" ON public.channels USING btree ("ID_Archive");


--
-- Name: fki_channelID; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "fki_channelID" ON public."archiveFiles" USING btree ("ID_Channel");


--
-- Name: fki_path->archivePaths; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "fki_path->archivePaths" ON public."archiveFiles" USING btree (path);


--
-- Name: fki_screenId; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "fki_screenId" ON public.windows USING btree ("ID_Screen");


--
-- Name: files trig_compute_archive_size; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER trig_compute_archive_size AFTER INSERT OR DELETE OR UPDATE ON public.files FOR EACH ROW EXECUTE PROCEDURE public.compute_archive_size();


--
-- Name: motionDetectorSettings Foreign_ID_Channels; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."motionDetectorSettings"
    ADD CONSTRAINT "Foreign_ID_Channels" FOREIGN KEY ("ID_Channel") REFERENCES public.channels("ID_Channel") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: lineIntersectionSettings Foreign_ID_Channels; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."lineIntersectionSettings"
    ADD CONSTRAINT "Foreign_ID_Channels" FOREIGN KEY ("ID_Channel") REFERENCES public.channels("ID_Channel") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: faceDbSettings Foreign_ID_Channels; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."faceDbSettings"
    ADD CONSTRAINT "Foreign_ID_Channels" FOREIGN KEY ("ID_Channel") REFERENCES public.channels("ID_Channel") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: heatmapSettings Foreign_ID_Channels; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."heatmapSettings"
    ADD CONSTRAINT "Foreign_ID_Channels" FOREIGN KEY ("ID_Channel") REFERENCES public.channels("ID_Channel") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: delObjsSettings Foreign_ID_Channels; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."delObjsSettings"
    ADD CONSTRAINT "Foreign_ID_Channels" FOREIGN KEY ("ID_Channel") REFERENCES public.channels("ID_Channel") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: archivePaths ID_Archive; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."archivePaths"
    ADD CONSTRAINT "ID_Archive" FOREIGN KEY ("ID_Archive") REFERENCES public.archives("ID_Archive") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: channels ID_Archive->archives; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.channels
    ADD CONSTRAINT "ID_Archive->archives" FOREIGN KEY ("ID_Archive") REFERENCES public.archives("ID_Archive") ON UPDATE CASCADE;


--
-- Name: events ID_Channel; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.events
    ADD CONSTRAINT "ID_Channel" FOREIGN KEY ("ID_Channel") REFERENCES public.channels("ID_Channel") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: videoCellItems ID_Channel(channel)&ID_Channel; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."videoCellItems"
    ADD CONSTRAINT "ID_Channel(channel)&ID_Channel" FOREIGN KEY ("ID_Channel") REFERENCES public.channels("ID_Channel") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: archiveFiles archiveID; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."archiveFiles"
    ADD CONSTRAINT "archiveID" FOREIGN KEY ("ID_Archive") REFERENCES public.archives("ID_Archive") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: archiveFiles channelID; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."archiveFiles"
    ADD CONSTRAINT "channelID" FOREIGN KEY ("ID_Channel") REFERENCES public.channels("ID_Channel") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userAccess channel_fKey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."userAccess"
    ADD CONSTRAINT "channel_fKey" FOREIGN KEY ("ID_Channel") REFERENCES public.channels("ID_Channel") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: customGrids customGrids_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."customGrids"
    ADD CONSTRAINT "customGrids_fkey" FOREIGN KEY ("ID_Screen") REFERENCES public."videoScreens"("ID_Screen") ON DELETE CASCADE;


--
-- Name: files path,filename->archiveFiles; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.files
    ADD CONSTRAINT "path,filename->archiveFiles" FOREIGN KEY (path, filename) REFERENCES public."archiveFiles"(path, filename);


--
-- Name: archiveFiles path->archivePaths; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."archiveFiles"
    ADD CONSTRAINT "path->archivePaths" FOREIGN KEY (path) REFERENCES public."archivePaths"(path) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: scheduleElements scheduleID; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."scheduleElements"
    ADD CONSTRAINT "scheduleID" FOREIGN KEY ("ID_Schedule") REFERENCES public."scheduleProfiles"("ID_Schedule") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: videoScreens screen_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."videoScreens"
    ADD CONSTRAINT screen_fkey FOREIGN KEY ("userId") REFERENCES public.users("ID_User") ON DELETE CASCADE;


--
-- Name: videoCellItems screen_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."videoCellItems"
    ADD CONSTRAINT screen_fkey FOREIGN KEY ("ID_Screen") REFERENCES public."videoScreens"("ID_Screen") ON DELETE CASCADE;


--
-- Name: videoCells screen_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."videoCells"
    ADD CONSTRAINT screen_fkey FOREIGN KEY ("ID_Screen") REFERENCES public."videoScreens"("ID_Screen") ON DELETE CASCADE;


--
-- Name: settings settings_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.settings
    ADD CONSTRAINT settings_fkey FOREIGN KEY ("userId") REFERENCES public.users("ID_User") ON DELETE CASCADE;


--
-- Name: videoCellItems videoCellItem_ID_Screen_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."videoCellItems"
    ADD CONSTRAINT "videoCellItem_ID_Screen_fkey" FOREIGN KEY ("ID_Screen", "ID_Cell") REFERENCES public."videoCells"("ID_Screen", "ID_Cell") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: windows windows_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.windows
    ADD CONSTRAINT windows_fkey FOREIGN KEY ("userId") REFERENCES public.users("ID_User") ON DELETE CASCADE;


ALTER TABLE ONLY public.channels ADD COLUMN "fastPipeline" BOOLEAN NOT NULL DEFAULT FALSE;

--
-- Name: TABLE "applicationEvents"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."applicationEvents" TO remote;


--
-- Name: TABLE "archiveFiles"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."archiveFiles" TO remote;


--
-- Name: TABLE "archivePaths"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."archivePaths" TO remote;


--
-- Name: TABLE archives; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public.archives TO remote;


--
-- Name: TABLE bookmarks; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public.bookmarks TO remote;


--
-- Name: TABLE channels; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public.channels TO remote;


--
-- Name: TABLE connections; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public.connections TO remote;


--
-- Name: TABLE "customGrids"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."customGrids" TO remote;


--
-- Name: TABLE "delObjsSettings"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."delObjsSettings" TO remote;


--
-- Name: TABLE events; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public.events TO remote;


--
-- Name: TABLE "faceDbSettings"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."faceDbSettings" TO remote;


--
-- Name: TABLE files; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public.files TO remote;


--
-- Name: TABLE "heatmapSettings"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."heatmapSettings" TO remote;


--
-- Name: TABLE "imageSettings"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."imageSettings" TO remote;


--
-- Name: TABLE journal; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public.journal TO remote;


--
-- Name: TABLE "lineIntersectionSettings"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."lineIntersectionSettings" TO remote;


--
-- Name: TABLE logon; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public.logon TO remote;


--
-- Name: TABLE "motionDetectorSettings"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."motionDetectorSettings" TO remote;


--
-- Name: TABLE "scheduleElements"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."scheduleElements" TO remote;


--
-- Name: TABLE "scheduleProfiles"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."scheduleProfiles" TO remote;


--
-- Name: TABLE settings; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public.settings TO remote;


--
-- Name: TABLE "userAccess"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."userAccess" TO remote;


--
-- Name: TABLE users; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public.users TO remote;


--
-- Name: TABLE "videoCellItems"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."videoCellItems" TO remote;


--
-- Name: TABLE "videoCells"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."videoCells" TO remote;


--
-- Name: TABLE "videoScreens"; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public."videoScreens" TO remote;


--
-- Name: TABLE windows; Type: ACL; Schema: public; Owner: postgres
--

GRANT ALL ON TABLE public.windows TO remote;

CREATE TABLE public."remoteChannels"
(
  "channelId" integer not null,
  "userId" integer not null,
  latency integer NOT NULL DEFAULT 500,
  "transportProtocol" integer DEFAULT 1,
  "fastPipeline" boolean NOT NULL DEFAULT false,
  "hwDecoder" boolean NOT NULL DEFAULT false,
  "rtspClient" integer not null default 1,
  CONSTRAINT "rc_pkey" PRIMARY KEY ("channelId", "userId")
);

GRANT ALL ON TABLE public."remoteChannels" TO postgres;
GRANT ALL ON TABLE public."remoteChannels" TO remote;

--
-- PostgreSQL database dump complete
--

