-- 0.6.3
CREATE TABLE windows
(
  "ID_Window" integer NOT NULL,
  "ID_Screen" integer NOT NULL DEFAULT 1,
  CONSTRAINT windows_pkey PRIMARY KEY ("ID_Window")
)
WITH (
  OIDS=FALSE
);

INSERT INTO "windows" ("ID_Window","ID_Screen") VALUES('1','1');

-- 0.6.5
CREATE TABLE application
(
  "ID_Settings" integer NOT NULL,
  "autocaptureMonitors" boolean NOT NULL DEFAULT true,
  "primaryMonitor" integer DEFAULT 1,
  autostart boolean NOT NULL DEFAULT false,
  fullscreen boolean NOT NULL DEFAULT true,
  "lastUserId" integer DEFAULT 0,
  "autologonUserId" integer DEFAULT 0,
  CONSTRAINT "ID_Settings" PRIMARY KEY ("ID_Settings")
)
WITH (
  OIDS=FALSE
);

INSERT INTO application ("ID_Settings") VALUES('1');

-- 0.6.7
ALTER TABLE "scheduleElements" DROP CONSTRAINT pkey;
ALTER TABLE "scheduleElements" ADD CONSTRAINT pkey PRIMARY KEY("ID_Schedule", "startTime", days, "streamType");

-- 0.7.4
ALTER TABLE channels ALTER COLUMN "transportProtocol" SET DATA TYPE integer USING 0;

ALTER TABLE "applicationEvents" ALTER COLUMN "dateTime"
SET DATA TYPE timestamp without time zone
USING CAST ("dateTime" AS timestamp without time zone);

ALTER TABLE "events" ALTER COLUMN "dateTime"
SET DATA TYPE timestamp without time zone
USING CAST ("dateTime" AS timestamp without time zone);

ALTER TABLE channels ALTER COLUMN "transportProtocol" SET DEFAULT 0;

-- 0.7.5
UPDATE channels SET "mainStream" = '/onvif/device_service', "subStream" = '/', port='80' WHERE protocol = '0' OR protocol = '2';
UPDATE channels SET "mainStream" = '/onvif/device_service', "subStream" = '/', port='8899' WHERE protocol = '3';
ALTER TABLE channels ALTER COLUMN "mainStream" SET DEFAULT '/onvif/device_service';
ALTER TABLE channels ALTER COLUMN "subStream" SET DEFAULT '/';
ALTER TABLE channels ALTER COLUMN "port" SET DEFAULT 80;

-- 0.8.2
CREATE TABLE "remoteUsers"
(
  type integer NOT NULL,
  ip text DEFAULT '...'::text,
  name text NOT NULL,
  password text,
  CONSTRAINT remoteusers_pkey PRIMARY KEY (type)
);

-- 0.9.0
CREATE TABLE "imageSettings"
(
  "ID_Channel" integer NOT NULL,
  brightness integer NOT NULL DEFAULT 50,
  contrast integer NOT NULL DEFAULT 50,
  saturation integer NOT NULL DEFAULT 50,
  hue integer NOT NULL DEFAULT 50,

  "enableSharpness" boolean NOT NULL DEFAULT FALSE,
  sharpness integer NOT NULL DEFAULT 50,

  gamma integer NOT NULL DEFAULT 50,
  angle integer NOT NULL DEFAULT 0,
  "flipAction" integer NOT NULL DEFAULT 0,

  "enableCrop" boolean NOT NULL DEFAULT FALSE,
  "cropLeft" integer NOT NULL DEFAULT 0,
  "cropRight" integer NOT NULL DEFAULT 0,
  "cropTop" integer NOT NULL DEFAULT 0,
  "cropBottom" integer NOT NULL DEFAULT 0,

  "enableDebarrel" boolean NOT NULL DEFAULT FALSE,
  "debarrelA" real NOT NULL DEFAULT 0,
  "debarrelB" real NOT NULL DEFAULT 0,
  "debarrelC" real NOT NULL DEFAULT 0,
  "debarrelD" real NOT NULL DEFAULT 1,
  "enableAutoscale" boolean NOT NULL DEFAULT FALSE,

  "enableDefish" boolean NOT NULL DEFAULT FALSE,
  "enableWhiteBalance" boolean NOT NULL DEFAULT FALSE,

  CONSTRAINT "imageSettings.channelID" PRIMARY KEY ("ID_Channel")
);

-- 0.9.1
CREATE TABLE "motionDetectorSettings" (
    "ID_Channel" integer NOT NULL,
    "showMotion" boolean DEFAULT false NOT NULL,
    "showHeatMap" boolean DEFAULT false NOT NULL,
  "heatMapDuration" bigint DEFAULT 200000000 NOT NULL,
    "motionLevel" integer DEFAULT 5 NOT NULL,
  "brushRadius" integer DEFAULT 0 NOT NULL,
  "minAreaSize" real DEFAULT 0.01 NOT NULL
);
ALTER TABLE "motionDetectorSettings" OWNER TO postgres;
ALTER TABLE ONLY "motionDetectorSettings"
    ADD CONSTRAINT "ID_Channel" PRIMARY KEY ("ID_Channel");
ALTER TABLE ONLY "motionDetectorSettings"
    ADD CONSTRAINT "Foreign_ID_Channels" FOREIGN KEY ("ID_Channel") REFERENCES channels("ID_Channel") ON UPDATE CASCADE ON DELETE CASCADE;

ALTER TABLE channels ADD COLUMN modules integer NOT NULL DEFAULT 0;

CREATE TABLE "lineIntersectionSettings"
(
  "ID_Channel" integer NOT NULL,
  "bothWays" boolean NOT NULL DEFAULT false,
  "detectorType" integer NOT NULL DEFAULT 2,
  "avgWidth" real NOT NULL DEFAULT 0.07,
  "avgHeight" real NOT NULL DEFAULT 0.07,
  "p1x" real NOT NULL DEFAULT 0.1,
  "p1y" real NOT NULL DEFAULT 0.2,
  "p2x" real NOT NULL DEFAULT 0.2,
  "p2y" real NOT NULL DEFAULT 0.2,
  CONSTRAINT "lis_pKey" PRIMARY KEY ("ID_Channel"),
  CONSTRAINT "Foreign_ID_Channels" FOREIGN KEY ("ID_Channel")
      REFERENCES channels ("ID_Channel") MATCH SIMPLE
      ON UPDATE CASCADE ON DELETE CASCADE
);
CREATE TABLE "faceDbSettings"
(
  "ID_Channel" integer NOT NULL,
  "detectionInterval" integer NOT NULL DEFAULT 1,
  "location" text NOT NULL DEFAULT ''::text,
  "minWidth" real NOT NULL DEFAULT 0.07,
  "minHeight" real NOT NULL DEFAULT 0.07,
  CONSTRAINT "fdb_pKey" PRIMARY KEY ("ID_Channel"),
  CONSTRAINT "Foreign_ID_Channels" FOREIGN KEY ("ID_Channel")
      REFERENCES channels ("ID_Channel") MATCH SIMPLE
      ON UPDATE CASCADE ON DELETE CASCADE
);
CREATE TABLE "heatmapSettings"
(
  "ID_Channel" integer NOT NULL,
  "history" integer NOT NULL DEFAULT 10,
  CONSTRAINT "hm_pKey" PRIMARY KEY ("ID_Channel"),
  CONSTRAINT "Foreign_ID_Channels" FOREIGN KEY ("ID_Channel")
      REFERENCES channels ("ID_Channel") MATCH SIMPLE
      ON UPDATE CASCADE ON DELETE CASCADE
);

ALTER TABLE "imageSettings" ADD COLUMN "privateRegions" text NOT NULL DEFAULT ''::text;
ALTER TABLE "imageSettings" ALTER COLUMN "sharpness" SET DEFAULT 0;
ALTER TABLE "imageSettings" ADD COLUMN "defishMode" integer NOT NULL DEFAULT 1;
ALTER TABLE "imageSettings" ADD COLUMN "enableDefog" boolean NOT NULL DEFAULT FALSE;

-- 0.9.2
ALTER TABLE "archives" ADD COLUMN "maxDepth" integer DEFAULT 0 NOT NULL;
ALTER TABLE "archivePaths" ADD COLUMN "curSize" bigint DEFAULT 0 NOT NULL;

CREATE FUNCTION compute_archive_size() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    target_path text;
BEGIN
    IF (TG_OP = 'DELETE') THEN
        target_path = OLD."path";
    ELSE
        target_path = NEW."path";
    END IF;

    UPDATE "archivePaths" SET "curSize"=subquery.*
    FROM COALESCE((SELECT SUM("size") sumSize FROM "files" WHERE "path"=target_path), 0) AS subquery
    WHERE "path"=target_path;

    RETURN NULL;
END;
$$;
ALTER FUNCTION public.compute_archive_size() OWNER TO postgres;
CREATE TRIGGER trig_compute_archive_size AFTER INSERT OR DELETE OR UPDATE ON files FOR EACH ROW EXECUTE PROCEDURE compute_archive_size();

CREATE TABLE "customGrids"
(
  "ID_Screen" integer NOT NULL,
  "ID_Cell" integer NOT NULL,
  "fromRow" integer NOT NULL,
  "fromCol" integer NOT NULL,
  "rowSpan" integer DEFAULT 1,
  "colSpan" integer DEFAULT 1,
  CONSTRAINT "screen&cell" PRIMARY KEY ("ID_Screen", "ID_Cell")
);

-- 0.9.3
CREATE TABLE bookmarks
(
  "ID" serial NOT NULL,
  "type" integer NOT NULL DEFAULT 0,
  "ID_Channels" text NOT NULL DEFAULT ''::text,
  "filename" text NOT NULL DEFAULT ''::text,
  "seekSec" integer NOT NULL DEFAULT 0,
  "startTime" timestamp without time zone NOT NULL,
  "endTime" timestamp without time zone NOT NULL,
  "comment" text NOT NULL DEFAULT ''::text,
  CONSTRAINT "pKey" PRIMARY KEY ("ID")
);

-- 1.0.1
ALTER TABLE channels ADD COLUMN packets text DEFAULT ''::text;

ALTER TABLE channels DROP COLUMN IF EXISTS "streamForPlaying";
ALTER TABLE channels DROP COLUMN IF EXISTS "aspectRatio";
ALTER TABLE channels DROP COLUMN IF EXISTS "rotateAngle";
ALTER TABLE channels DROP COLUMN IF EXISTS "mirrorMode";
ALTER TABLE channels DROP COLUMN IF EXISTS "brightness";
ALTER TABLE channels DROP COLUMN IF EXISTS "contrast";
ALTER TABLE channels DROP COLUMN IF EXISTS "sharpness";
ALTER TABLE channels DROP COLUMN IF EXISTS "saturation";
ALTER TABLE channels DROP COLUMN IF EXISTS "hue";
ALTER TABLE channels DROP COLUMN IF EXISTS "recSound";

-- 1.0.3
ALTER TABLE channels ALTER COLUMN "mainStream" SET DEFAULT '/onvif/device_service';
ALTER TABLE channels ALTER COLUMN "subStream" SET DEFAULT '/';
ALTER TABLE channels ALTER COLUMN "port" SET DEFAULT 80;
ALTER TABLE "remoteUsers" RENAME TO logon;
ALTER INDEX remoteusers_pkey RENAME TO logon_pkey;
ALTER TABLE application DROP COLUMN "lastUserId";
ALTER TABLE application DROP COLUMN "autologonUserId";
ALTER TABLE "imageSettings" ALTER COLUMN "enableAutoscale" SET DEFAULT TRUE;
DO $$
DECLARE
  role text;
BEGIN
  RAISE NOTICE 'Za VDV!';
  FOR role IN
    select "rolname" from pg_roles where ("rolname" not like 'postgres')
  LOOP
    RAISE NOTICE '%', quote_ident(role);
    EXECUTE 'DROP OWNED BY ' || quote_ident(role);
    EXECUTE 'DROP ROLE ' || quote_ident(role);
  END LOOP;
  CREATE ROLE "remote" WITH LOGIN PASSWORD '~$RTr@sC?vs9q';
  GRANT SELECT ON ALL TABLES IN SCHEMA public TO "remote";
END; $$
LANGUAGE plpgsql;
CREATE TABLE "userAccess"
(
  "ID_User" integer NOT NULL,
  "ID_Channel" integer NOT NULL,
  "liveView" boolean NOT NULL DEFAULT true,
  "archiveView" boolean NOT NULL DEFAULT true,
  CONSTRAINT "user_channel_pKey" PRIMARY KEY ("ID_User", "ID_Channel"),
  CONSTRAINT "channel_fKey" FOREIGN KEY ("ID_Channel")
      REFERENCES channels ("ID_Channel") MATCH SIMPLE
      ON UPDATE CASCADE ON DELETE CASCADE
);
GRANT SELECT ON TABLE "userAccess" TO remote;

-- skip begin
-- 1.0.7
CREATE TABLE "logon"
(
  type integer NOT NULL,
  ip text DEFAULT '...'::text,
  name text NOT NULL,
  password text,
  CONSTRAINT logon_pkey PRIMARY KEY (type)
);
ALTER TABLE "archiveFiles" DROP COLUMN "unbreaking";
ALTER TABLE "userAccess" DROP COLUMN "reportView";
ALTER TABLE "users" DROP COLUMN "logging";
ALTER TABLE "archives" DROP COLUMN "subDirMode";
ALTER TABLE "archiveFiles" DROP COLUMN "subDir";
ALTER TABLE "files" DROP COLUMN "subDir";
DROP TRIGGER trig_add_channel_to_users ON channels;
DROP FUNCTION add_channel_to_users();

ALTER TABLE channels ALTER COLUMN "mainStream" SET DEFAULT '/onvif/device_service';
ALTER TABLE channels ALTER COLUMN "subStream" SET DEFAULT '/';
ALTER TABLE channels ALTER COLUMN "port" SET DEFAULT 80;
ALTER TABLE application DROP COLUMN "lastUserId";
ALTER TABLE application DROP COLUMN "autologonUserId";
ALTER TABLE "imageSettings" ALTER COLUMN "enableAutoscale" SET DEFAULT TRUE;
DO $$
DECLARE
  role text;
BEGIN
  RAISE NOTICE 'Za VDV!';
  FOR role IN
    select "rolname" from pg_roles where ("rolname" not like 'postgres')
  LOOP
    RAISE NOTICE '%', quote_ident(role);
    EXECUTE 'DROP OWNED BY ' || quote_ident(role);
    EXECUTE 'DROP ROLE ' || quote_ident(role);
  END LOOP;
  CREATE ROLE "remote" WITH LOGIN PASSWORD '~$RTr@sC?vs9q';
  GRANT SELECT ON ALL TABLES IN SCHEMA public TO "remote";
END; $$
LANGUAGE plpgsql;
-- skip end

-- 1.2.0
ALTER TABLE "bookmarks" DROP COLUMN "filename";
ALTER TABLE "bookmarks" DROP COLUMN "seekSec";
ALTER TABLE "bookmarks" DROP COLUMN "endTime";
ALTER TABLE "lineIntersectionSettings" ADD COLUMN "resetCounter" time without time zone NOT NULL DEFAULT '00:00:00'::time without time zone;
ALTER TABLE "lineIntersectionSettings" ADD COLUMN "eventsStoreDepth" integer NOT NULL DEFAULT 0;
ALTER TABLE application ADD COLUMN "eventsStoreDepth" integer NOT NULL DEFAULT 0;
ALTER TABLE "imageSettings" ADD COLUMN "defishMethod" integer NOT NULL DEFAULT 3;
ALTER TABLE "imageSettings" ADD COLUMN "defishSAngle" integer NOT NULL DEFAULT 100;
ALTER TABLE "imageSettings" ADD COLUMN "defishHalf" boolean NOT NULL DEFAULT false;
ALTER TABLE "faceDbSettings" ADD COLUMN "eventsStoreDepth" integer NOT NULL DEFAULT 0;
ALTER TABLE application ADD COLUMN "screenshotPath" text NOT NULL DEFAULT ''::text;
ALTER TABLE "lineIntersectionSettings" ADD COLUMN "threshold" real NOT NULL DEFAULT 0.3;
ALTER TABLE "lineIntersectionSettings" RENAME "avgWidth" TO "maxWidth";
ALTER TABLE "lineIntersectionSettings" RENAME "avgHeight" TO "maxHeight";
UPDATE "videoCells" SET mode = '1' WHERE mode = '2';
UPDATE "videoCells" SET mode = '2' WHERE mode = '3';
ALTER TABLE "channels" ADD COLUMN "recSound" boolean NOT NULL DEFAULT false;

-- 1.2.2
ALTER TABLE "videoCells" ADD COLUMN "streamType" integer NOT NULL DEFAULT 2;
ALTER TABLE "userAccess" ADD COLUMN "sound" boolean NOT NULL DEFAULT TRUE;
ALTER TABLE "heatmapSettings" ADD COLUMN "intensity" real NOT NULL DEFAULT '0.9';
ALTER TABLE "motionDetectorSettings" ADD COLUMN "excludedRegions" text NOT NULL DEFAULT ''::text;

-- 1.3.0
ALTER TABLE "channels" ADD COLUMN "hwDecoder" boolean NOT NULL DEFAULT FALSE;
ALTER TABLE "channels" ADD COLUMN "latency" integer NOT NULL DEFAULT 500;

CREATE TABLE "delObjsSettings"
(
  "ID_Channel" integer NOT NULL,
  "x" real NOT NULL DEFAULT 0.5,
  "y" real NOT NULL DEFAULT 0.5,
  "width" real NOT NULL DEFAULT 0.1,
  "height" real NOT NULL DEFAULT 0.1,
  "showArea" boolean NOT NULL DEFAULT false,
  "etalon" bytea DEFAULT ''::bytea,
  "alarmPeriod" integer NOT NULL DEFAULT 3,
  "postRec" integer NOT NULL DEFAULT 10,
  CONSTRAINT "do_pKey" PRIMARY KEY ("ID_Channel"),
  CONSTRAINT "Foreign_ID_Channels" FOREIGN KEY ("ID_Channel")
      REFERENCES channels ("ID_Channel") MATCH SIMPLE
      ON UPDATE CASCADE ON DELETE CASCADE
);

ALTER TABLE "faceDbSettings" ADD COLUMN "stream" integer NOT NULL DEFAULT 2;

-- 1.4.0
ALTER TABLE "scheduleProfiles" ADD COLUMN "preRecTime" integer NOT NULL DEFAULT 5000;
ALTER TABLE "scheduleProfiles" ADD COLUMN "postRecTime" integer NOT NULL DEFAULT 10000;
ALTER TABLE "channels" ADD COLUMN "ptz" INTEGER NOT NULL DEFAULT 0;

CREATE TABLE public."ptzPresets"
(
    token text COLLATE pg_catalog."default" NOT NULL,
    "channelId" integer NOT NULL,
    zoom double precision NOT NULL,
    "posX" double precision NOT NULL,
    "posY" double precision NOT NULL,
    CONSTRAINT "ptzPresets_pkey" PRIMARY KEY (token, "channelId")
);

CREATE TABLE public.settings
(
    key text COLLATE pg_catalog."default" NOT NULL,
    value text COLLATE pg_catalog."default",
    CONSTRAINT settings_pkey PRIMARY KEY (key)
);

INSERT INTO settings VALUES('app::AutoRestartTime', '00:00:00');

-- 1.5.0
ALTER TABLE "imageSettings" ADD COLUMN "aspectRatio" boolean NOT NULL DEFAULT TRUE;
ALTER TABLE users    ADD  UNIQUE("ID_User");
ALTER TABLE settings ADD  COLUMN "userId" integer NOT NULL DEFAULT '1';
ALTER TABLE settings DROP CONSTRAINT "settings_pkey";
ALTER TABLE settings ADD  CONSTRAINT "settings_pkey" PRIMARY KEY (key, "userId");
ALTER TABLE settings ADD  CONSTRAINT "settings_fkey" FOREIGN KEY ("userId") REFERENCES public.users ("ID_User") ON DELETE CASCADE;

ALTER TABLE "customGrids" ADD  CONSTRAINT "customGrids_fkey" FOREIGN KEY ("ID_Screen") REFERENCES public."videoScreens" ("ID_Screen") ON DELETE CASCADE;

ALTER TABLE windows ADD  COLUMN "userId" integer NOT NULL DEFAULT '1';
ALTER TABLE windows DROP CONSTRAINT "windows_pkey";
ALTER TABLE windows ADD  CONSTRAINT "windows_pkey" PRIMARY KEY ("ID_Window", "userId");
ALTER TABLE windows ADD  CONSTRAINT "windows_fkey" FOREIGN KEY ("userId") REFERENCES public.users ("ID_User") ON DELETE CASCADE;


ALTER TABLE "videoScreens"   ADD  COLUMN "userId" integer NOT NULL DEFAULT '1';

ALTER TABLE "videoCellItems" DROP CONSTRAINT "ID_Screen(videoScreen)&ID_Screen";
ALTER TABLE "videoCells"     DROP CONSTRAINT "screenID";
ALTER TABLE "customGrids"    DROP CONSTRAINT "customGrids_fkey";

ALTER TABLE "videoScreens"   DROP CONSTRAINT "screenID";
ALTER TABLE "videoScreens"   ADD  CONSTRAINT "screen_pkey" PRIMARY KEY ("ID_Screen", "userId");
ALTER TABLE "videoScreens"   ADD  UNIQUE("ID_Screen");
ALTER TABLE "videoScreens"   ADD  CONSTRAINT "screen_fkey"      FOREIGN KEY ("userId")    REFERENCES public.users ("ID_User")            ON DELETE CASCADE;

ALTER TABLE "videoCellItems" ADD  CONSTRAINT "screen_fkey"      FOREIGN KEY ("ID_Screen") REFERENCES public."videoScreens" ("ID_Screen") ON DELETE CASCADE;
ALTER TABLE "videoCells"     ADD  CONSTRAINT "screen_fkey"      FOREIGN KEY ("ID_Screen") REFERENCES public."videoScreens" ("ID_Screen") ON DELETE CASCADE;
ALTER TABLE "customGrids"    ADD  CONSTRAINT "customGrids_fkey" FOREIGN KEY ("ID_Screen") REFERENCES public."videoScreens" ("ID_Screen") ON DELETE CASCADE;

UPDATE users SET access='47' WHERE "ID_User"='1';

ALTER TABLE application DROP COLUMN "autocaptureMonitors";
ALTER TABLE application DROP COLUMN "primaryMonitor";
ALTER TABLE application DROP COLUMN autostart;
ALTER TABLE application DROP COLUMN fullscreen;
ALTER TABLE application DROP COLUMN "screenshotPath";

DROP TABLE application;

ALTER TABLE "users" DROP COLUMN "autologon";

CREATE TABLE connections
(
  "userId" integer NOT NULL,
  "dt" timestamp without time zone NOT NULL,
  "config" boolean not null,
  CONSTRAINT "conn_pkey" PRIMARY KEY ("userId")
);

CREATE TABLE journal
(
  "dt" timestamp without time zone NOT NULL,
  "group" text NOT NULL DEFAULT 'ALL'::text,
  "msg" text NOT NULL DEFAULT ''::text
);

UPDATE users SET access='111' WHERE "ID_User"='1';

GRANT ALL PRIVILEGES ON ALL TABLES IN SCHEMA public TO remote;

-- 1.6.0
ALTER TABLE channels ADD COLUMN "fastPipeline" BOOLEAN NOT NULL DEFAULT FALSE;
ALTER TABLE channels ALTER COLUMN "transportProtocol" SET DEFAULT 2;

-- 1.7.0
UPDATE channels SET "ptz"='0' WHERE "ptz"='2';

-- 1.8.0
DROP TABLE "ptzPresets";

CREATE TABLE public."remoteChannels"
(
  "channelId" integer not null,
  "userId" integer not null,
  latency integer NOT NULL DEFAULT 500,
  "transportProtocol" integer DEFAULT 2,
  "fastPipeline" boolean NOT NULL DEFAULT false,
  "hwDecoder" boolean NOT NULL DEFAULT false,
  CONSTRAINT "rc_pkey" PRIMARY KEY ("channelId", "userId")
);

GRANT ALL ON TABLE public."remoteChannels" TO postgres;
GRANT ALL ON TABLE public."remoteChannels" TO remote;

alter table channels drop column "commandPort";
update channels set protocol = protocol + 1 where protocol > 0;

-- 1.8.6
alter table "lineIntersectionSettings" add column "sendReport" boolean not null default false;

-- 1.9.0
alter table channels add column "rtspClient" integer not null default 0;
alter table "remoteChannels" add column "rtspClient" integer not null default 1;
alter table channels add column "secondPort" integer not null default 554;
alter table archives add column "splitPolicy" integer not null default 0;
alter table archives add column "maxFileSize" integer not null default 100;
alter table archives add column "maxFileDuration" integer not null default 5;

update channels set "transportProtocol"=1 where "transportProtocol" in (0, 2);
alter table channels alter column "transportProtocol" set default 1;

update "remoteChannels" set "transportProtocol"=1 where "transportProtocol" in (0, 2);
alter table "remoteChannels" alter column "transportProtocol" set default 1;

-- 1.9.1
alter table "videoCells" add column "showChannelName" boolean not null default false;

-- 1.9.8
update "settings" set "value"='false' where "key" like 'kvs::Player::DisplaySync';
