####################################################
# For compiling in single exe file use:
# > pip install py2exe
# > c:\Python34\Scripts\build_exe.exe update.py -O -b 1 -c
#
# Usage:
# update <db_version> <current_iviset_version> <dbname>
####################################################
import sys
import os
import subprocess

def isNewVersion(ver1, ver2):
    ver1 = ver1.split('.')
    ver2 = ver2.split('.')
    for (i, j) in zip(ver1, ver2):
        if i < j:
            return True
        elif i > j:
            return False
    else:
        return False

if sys.platform.startswith('win32'):
    tempsqlpath = 'temp.sql'
elif sys.platform.startswith('linux'):
    tempsqlpath = '/tmp/temp.sql'

f = open('patches.sql', 'r')
db_version = sys.argv[1] # 12
currentVersion = sys.argv[2] #'1.0.2'
if len(sys.argv) > 3:
    dbname = sys.argv[3]
else:
    dbname = 'iviset'

for text in f:
    if text.startswith('--') and text[3:7]!='skip':
        version = text[3:-1]
        if isNewVersion(currentVersion, version):
            print 'New version is ' + version
            break

w = open(tempsqlpath, 'w')
skipState = False
for text in f:
    if not skipState:
        if text[:-1]!='-- skip begin':
            w.write(text)
        else:
            skipState = True
    elif text[:-1]=='-- skip end':
        skipState = False
w.flush()
w.close()
f.close()

if sys.platform.startswith('win32'):
    output = subprocess.check_output([r'c:\\Program Files\\PostgreSQL\\' + db_version + r'\\bin\\psql.exe',
                  '--file='+tempsqlpath, '--host=localhost', '--port=5437',
                  '--username=postgres', '--dbname='+dbname], shell=True)
elif sys.platform.startswith('linux'):
    output = subprocess.check_output(['psql',
                  '--file='+tempsqlpath, '--host=localhost', '--port=5437',
                  '--username=postgres', '--dbname='+dbname])

os.remove(tempsqlpath)
